// Copyright 1995 Barbara Liskov

/*
\section{OR Configuration Information}

This module groups together various configuration parameters into one
structure.  The module will have to be extended as more configuration
parameters become necessary.
*/

#ifndef _OR_CONFIG_H
#define _OR_CONFIG_H

#include "utils/basic.h"
#include "utils/bits.h"
#include "common/or_num.h"
#include "config/vdefs/REPLICATION.h"

// Information supplied at OR initialization time.
class OR_init_config;

class OR_config {
  public:
    // Port number for server socket that listens to FEs
    int fe_socket;
    // Port number for server socket that listens to ORs
    int or_socket;

    OR_num ornum;  // OR number. Has to be initialized.

    // OR backing store.
    char const* disk;

    // Cache size (in bytes)
    int cache_size;

    // Log size (in bytes)
    int log_size;

    // Log application should start when this percent of log is full
    int apply_threshold;

    // Log cleaning should try to clean enough of the log to make it
    // this percent full.
    int target_percent;

    bool simulate_log_flush; // whether to simulate time taken for log flush

#if REPLICATION
    bool with_backups; // whether we are running alone or with backups
    bool two_backups;  // whether we have two or one backup	
#endif	

    // policy for fetching data to FE
    bool fetch_mods;  // allow sending mods when FE has a reparable segment
    bool fetch_cache; // allow fetching segment from cache
    bool fetch_complete; // allow forwarding fetch to FE with complete seg
    bool fetch_reparable; // allow forwarding fetch to FE with reparable seg
    bool fetch_disk; // allow fetching segment from disk

    // policy for iread
    bool iread_complete; // allow ireads from FEs with complete seg
    bool iread_reparable; // allow ireads from FEs with reparable seg
    bool iread_mods; // whether to send mods to ireads from reparable seg

    // policy for propagating updates
    bool send_updates; // append updated objects to invalidations
    bool send_updates_at_commit; // send updates right during commits


    // Printing debug information. Higher number means more information
    int debug_level;

    // Debug specific aspects
    bool debug_coop; // debug cooperative caching & iread-avoidance code

    bool print_time; // Print the performance information in the OR

    // Number of clients in experiment
    int num_clients;

    int eager_prefetch; // If 0, eager prefetching is not used else this
    // specifies the number of pages that are sent in a prefetch message

    // Initialization information.  Null if not initializing
    OR_init_config* init;
};

#define OR_CONFIG_DEFAULT_FILE		"sample.or"
#define OR_DEFAULT_CACHE_SIZE		(4*1024*1024)
#define OR_DEFAULT_LOG_SIZE		(6*1024*1024)
#define OR_DEFAULT_APPLY_PERCENT	90
#define OR_DEFAULT_TARGET_PERCENT	80

class OR_init_config {
  public:
    // Name of the file used to generate the initial database.
    // If 0 use the default initialization string.
    char const* input_file;

    // Size of the disk in disk blocks.
    int size;

    // Preferred segment size in disk blocks.
    int segsize;
};

#endif /* _OR_CONFIG_H */

