// Copyright 1995 Barbara Liskov

#include "utils/network.h"
#include "mm/logrecord.h"
#include "or_or_msg.h"

// These encode/decode methods are rather complex.  The reason is so
// that we can just pass in an or_or_msg to an OR and have it send
// the entire message for us, even when the message is of variable
// length.  Otherwise sending a message to an OR would involve extracting
// the network connection from the OR, and ensuring atomic actions on messages
// would be more difficult.

bool or_or_message::encode(Network* net) const {
    if (!net->send_ubits32(msgtype, TRUE) || !tid.encode(net))
	return FALSE;
    if (msgtype == OR_VOTE_OK || msgtype == OR_COMMIT) return TRUE;
    th_assert(msgtype == OR_VOTE_OK_CL, "Bad or message");
    or_or_vote_ok const *v = &u.vote_ok;

    // Send prepare record for coordinator log protocol
    return v->pr->encode(net) && net->send_ubits32(v->index, FALSE);
}

bool or_or_message::decode(Network* net) {
    if (!net->recv_ubits32(&msgtype) || !tid.decode(net))
	return FALSE;

    if (msgtype == OR_VOTE_OK || msgtype == OR_COMMIT) return TRUE;
    th_assert(msgtype == OR_VOTE_OK_CL, "Bad or message");
    or_or_vote_ok *v = &u.vote_ok;

    // Get prepare record for coordinator log protocol
    v->pr = new Prepared_Log_Record();
    return v->pr->decode(net) && net->recv_ubits32((Ubits32 *) &v->index);
}
