#ifndef _OR_SEND_DATA_MSG_H
#define _OR_SEND_DATA_MSG_H

#include "utils/send_message.h"
#include "common/oref.h"
#include "common/or_message.h"

class FE_manager;

class OR_send_data_msg: public Send_message {
    // Overview: This message is used for the fetch reply
  public:
    OR_send_data_msg(FE_manager *fe_manager, Oref oref, 
	     Seg_bmap prefetch_bmap, bool alloc_request, Ubits32 msg_id);
    // To send data containing object "oref" and prefetch pages in the
    // segment indicated by prefetch_bmap.
    // All pages are sent in the order of their page numbers.
    // If "alloc_request", grant allocation rights if possible.
    // msg_id is the id of the received fetch request

    Ubits32 type() const {return OR_data_type;}

    bool encode(Network *net);

  private:
    FE_manager *fe_manager;
    Oref oref;
    Seg_bmap prefetch_bmap;
    bool alloc_request;
    Ubits32 msg_id;
};

#endif /* _OR_SEND_DATA_MSG_H */
