#include "or_send_message.h"
#include "utils/network.h"

bool OR_send_commit_reply_msg::encode(Network *net) {
    bool success = net->send_ubits32(result, FALSE);
    if (!success)
	perror("Commit reply not successfully sent");
    if (!net->flush())
	perror("Network flush in commit reply failed");
    return success;
}

bool OR_send_invalidation_msg::encode(Network* net) {
    if (! (net->send_ubits32(count, TRUE) &&
	   net->send_ubits32(msg_start, TRUE) && 
	   net->send_ubits32(msg_end, TRUE))) {
	perror("Invalidation message not sent correctly");
	return FALSE;
    }
    if (!net->send_buffer(orefs, count*sizeof(Oref))) {
	perror("Invalidation message not sent correctly");
	return FALSE;
    }
    // No need to flush the message
    return TRUE;
}

bool OR_send_alloc_reply_msg::encode(Network *net) {
    int bmap_bytes = (bmap.size() + byte_bits - 1)/byte_bits;
    if (!net->send_ubits32(segid, TRUE) 
	|| !net->send_buffer(&bmap, bmap_bytes, TRUE)
	|| !net->send_buffer(&empty_bmap, bmap_bytes, FALSE)) {
	perror("Allocation grant reply not successfully sent");
	return FALSE;
    }
    return net->flush();
}

bool OR_send_debug_reply_msg::encode(Network *net) {
    return net->flush();
}

bool Send_net_message(Send_message *sm, Network *net, Ubits32 id) {
    // The order of entities has to be kept in sync with Communication::send
    if (! (net->send_ubits32 (id, TRUE) && net->send_ubits32 (sm->type(), TRUE)
	   && sm->encode(net))) {
        return FALSE;
    }
    return TRUE;
}
