#ifndef _OR_SEND_MESSAGE_H
#define _OR_SEND_MESSAGE_H

// This file has all the messages that are sent by the OR   AND
// require OR-sepcific data strutures to be used. The other messages sent by
// the OR are in common/or_message.h

#include "utils/basic.h"
#include "utils/bits.h"
#include "utils/send_message.h"

#include "common/oref.h"
#include "common/or_message.h"
#include "or.h"
#include "mm/mm.h"

class Network;

class OR_send_root_msg: public Send_message {
    // Overview: Reply to a get_root message
  public:
    Ubits32 type() const {return OR_root_type;}
    bool encode(Network* net) {
	return net->send_ubits32(orx->mm->directory(), FALSE);
    }
};

class OR_send_commit_reply_msg: public Send_message {
    // Overview: Reply to a commit message 
  public:
    OR_send_commit_reply_msg(Ubits32 com_result) : result(com_result) {}
    // effects: Creates a message with the commit result being "com_result"
    //          See or_message.h for interpretation of com_result

    bool encode(Network* net);

    Define_message_type(OR_commit_reply_type);

  private:
    Ubits32 result; // Commit result (see or_message.h for interpretation)
};


class OR_send_invalidation_msg:  public Send_message {
    // Overview: Invalidation message sent to the FE (asynchronous) 
  public:
    OR_send_invalidation_msg(int num, Oref* inv_orefs, int start, int end):
	count(num), msg_start(start), msg_end(end), orefs(inv_orefs) {}
    // requires: inv_orefs have a size of num
    // effects: Creates an inv message for sending "num" orefs from inv_orefs.
    //          The range msg_start ... msg_end indicates the invalidation
    //          message numbers to which these orefs belong

    bool encode(Network* net);

    Define_message_type(OR_invalidation_type);

  private:
    Ubits32     count;      // Number of invalid objects
    Ubits32     msg_start;  // The range of invalidation message
    Ubits32     msg_end;    // numbers being sent in this mesage
    Oref*       orefs;      // Invalid objects
};

class OR_send_alloc_reply_msg:  public Send_message {
    // Overview: For sending allocation rights granted to the FE
  public:
    OR_send_alloc_reply_msg(int seg, Seg_bmap bitmap, Seg_bmap empty) :
	segid(seg), bmap(bitmap), empty_bmap(empty) {}
	// effects: Creates a message indicating that the FE has allocation
	//          rights in "segid" on pages that have their pages set in
	//          "bmap". empty indicates which pages are empty and need not
        //          be present in the FE cache for the FE to allocate objects on

    bool encode(Network* net);

    Define_message_type(OR_alloc_reply_type);

  private:
    Ubits32     segid;      // Segment id where rights are being granted
    Seg_bmap    bmap;       // Bitmap for segid to indicate which pages
                            // the FE is being allocation rights
    Seg_bmap    empty_bmap; // Which pages are empty and need not be fetched
                            // by FE before it can allocate objects on that page
};

class OR_send_debug_reply_msg: public Send_message {
    // Overview: Reply to a debug message 
  public:
    OR_send_debug_reply_msg() {}
    // effects: Creates a debug reply message with appropriate params
    bool encode(Network* net);
    Define_message_type(OR_debug_reply_type);

  private:
};

extern bool Send_net_message(Send_message *sm, Network *net, Ubits32 id);
// effects: Sends message "sm" on network "net" with request id "id"

#endif /* _OR_SEND_MESSAGE_H */
