// Copyright 1995 Barbara Liskov

/*
\section{Read-Write Lock}

A read-write lock allows multiple readers, single writer.  Deadlock
avoidance is the responsibility of the caller.

RW_lock is an abstract class; different implementations are available 
as its subclasses: 

  RW_lock_mutex (rwlock_mutex.h):   allows no concurrency but is fifo-fair
  RW_lock_unfair (rwlock_unfair.h): allows concurrency but may starve writers
  RW_lock_fifo (rwlock_fifo.h):     allows concurrency and is fifo-fair

None of these implementations allows a thread holding a read lock to 
upgrade it to a write lock.

To create a RW_lock, call the constructor of the desired subclass and then 
use it as a RW_lock.
*/

#ifndef _RWLOCK_H
#define _RWLOCK_H

class RW_lock {
  public:

    virtual ~RW_lock() {};
    // requires	Nobody holds a lock or is waiting for a lock.
    // effects	Destroys lock.

    virtual void read_lock() = 0;
    // requires	Calling thread does not hold either a read/write lock.
    // effects	Acquires read lock.

    virtual void read_unlock() = 0;
    // requires	Calling thread has a read lock.
    // effects	Releases read lock.

    virtual void write_lock() = 0;
    // requires	Calling thread does not hold either a read/write lock.
    // effects	Acquires write lock.

    virtual void write_unlock() = 0;
    // requires	Calling thread has a write lock.
    // effects	Releases write lock.
};

#endif /* _RWLOCK_H */
