// Copyright 1995 Barbara Liskov

/*
\section{Read-Write Lock: non-concurrent but fair implmentation}

RW_lock_mutex implements RW_lock. It does not allow concurrent readers. It
is the implementation of choice when there is little concurrency among
readers.  
*/

#ifndef _RWLOCK_MUTEX_H
#define _RWLOCK_MUTEX_H

#include "thread.h"
#include "rwlock.h"


class RW_lock_mutex : public RW_lock {
  public:

    RW_lock_mutex();

    virtual ~RW_lock_mutex();

    virtual void read_lock();

    virtual void read_unlock();

    virtual void write_lock();

    virtual void write_unlock();

  private:

    Mutex m;
};

#endif /* _RWLOCK_MUTEX_H */
