// Copyright 1995 Barbara Liskov

/*
\section{Read-Write Lock Implementation: Concurrent but unfair}

Implemented using one mutex and one condition var.
*/

#include "thread.h"
#include "rwlock.h"
#include "rwlock_unfair.h"


RW_lock_unfair::RW_lock_unfair() {
    readers = 0;
    writers = 0;
    m = new Mutex;
    c = new Condition(m);
}

RW_lock_unfair::~RW_lock_unfair() {
    delete m;
    delete c; // is this the recommended order?
}

void RW_lock_unfair::read_lock() {
    m->grab();
    while (writers > 0) c->wait();
    readers++;
    m->release();
}

void RW_lock_unfair::read_unlock() {
    m->grab();
    readers--;
    if (readers == 0) c->signal();
    m->release();
}

void RW_lock_unfair::write_lock() {
    m->grab();
    while (readers > 0 || writers > 0) c->wait();
    writers++;
    m->release();
}

void RW_lock_unfair::write_unlock() {
    m->grab();
    writers--;
    c->broadcast();
    m->release();
}
