// Copyright 1995 Barbara Liskov

/*
\section{Read-Write Lock: concurrent but unfair implmentation}

RW_lock_unfair implements RW_lock. It allows concurrent readers.
It is biased in favor of the readers and may starve the writers.
If one thread has a read lock, this always allows another reader 
-- even if a writer is waiting.

*/

#ifndef _RWLOCK_UNFAIR_H
#define _RWLOCK_UNFAIR_H

#include "thread.h"
#include "rwlock.h"


class RW_lock_unfair : public RW_lock {
  public:

    RW_lock_unfair();

    virtual ~RW_lock_unfair();

    virtual void read_lock();

    virtual void read_unlock();

    virtual void write_lock();

    virtual void write_unlock();

  private:

    int readers;   // num of readers
    int writers;   // num of writers
    Mutex *m;
    Condition *c;
};

#endif /* _RWLOCK_UNFAIR_H */
