// Copyright 1995 Barbara Liskov

#include "oo7.h"
#include "common/wk_xref.h"

// Macro for finding an object given an oref
#define FIND_OBJECT(T,o) ((T*) locate_tagged_object(WK_ ## T ## _OREF, o))

// External routine that actually finds an object
extern Thor_Object* locate_tagged_object(bits32 class_tag, Oref);

Thor_Object::Thor_Object(OR_obj* o) {
    rep = o;
}

VecOfAny::VecOfAny(OR_obj* o) : Thor_Object(o) {
}

int VecOfAny::length() {
    return rep->slot[0].value32[0];
}

Oref VecOfAny::fetch(int i) {
    assert((i >= 0) && (i < length()));
    return rep->slot[i+1].oref;
}

void VecOfAny::store(int i, Oref o) {
    assert((i >= 0) && (i < length()));
    rep->slot[i+1].oref = o;
}
DesignObj:: DesignObj(OR_obj* o) : Thor_Object(o){
// builddate     slot[0].value32[1]
// id            slot[0].value32[0]
// otype         slot[1].oref
}
int DesignObj :: id(){
  return rep->slot[0].value32[0];
}

String* DesignObj :: otype(){
  return FIND_OBJECT(String, rep->slot[1].oref);
}

int DesignObj :: buildDate(){
  return rep->slot[0].value32[1];
}
void DesignObj :: set_buildDate(int v){
  rep->slot[0].value32[1]= v;
}



AtomicPart::AtomicPart(OR_obj* o) : DesignObj(o) {
}

int AtomicPart::x() { return rep->slot[0].value32[0]; }
int AtomicPart::y() { return rep->slot[0].value32[1]; }

void AtomicPart::set_x(int v) { rep->slot[0].value32[0] = v; }
void AtomicPart::set_y(int v) { rep->slot[0].value32[1] = v; }

int AtomicPart::docId() { return rep->slot[1].value32[0]; }

int AtomicPart::numOutgoing() {
    VecOfAny* v = FIND_OBJECT(VecOfAny, rep->slot[2].oref);
    return v->length();
}

Connection* AtomicPart::outgoingIndex(int i) {
// length  slot[0].value32[0]
// otype_  slot[1].oref
// from_   slot[2].oref
// to_     slot[3].oref
    VecOfAny* v = FIND_OBJECT(VecOfAny, rep->slot[2].oref);
    return FIND_OBJECT(Connection, v->fetch(i));
}

 Connection:: Connection(OR_obj* o): Thor_Object(o){
 }
 String* Connection:: otype(){
   return FIND_OBJECT(String, rep->slot[1].oref);
 }
int Connection:: length(){
  return rep->slot[0].value32[0];
}
AtomicPart* Connection:: from(){
  return FIND_OBJECT(AtomicPart, rep->slot[2].oref);
}
AtomicPart* Connection:: to(){
  return FIND_OBJECT(AtomicPart, rep->slot[3].oref);
}
 CompositePart:: CompositePart(OR_obj* o): DesignObj(o){
// doc         slot[2].oref
// privAssms   slot[3].oref
// sharAssms   slot[4].oref
// parts       slot[5].oref
// root        slot[6].oref
}
Document* CompositePart:: documentation(){
  return FIND_OBJECT(Document, rep->slot[2].oref);
}
int CompositePart:: numUsedPriv(){
    VecOfAny* v = FIND_OBJECT(VecOfAny, rep->slot[3].oref);
    return v->length();
}
BaseAssembly* CompositePart:: usedPrivIndex(int i){
  VecOfAny* v = FIND_OBJECT(VecOfAny, rep->slot[3].oref);
  return FIND_OBJECT(BaseAssembly, v->fetch(i));
}
int CompositePart:: numUsedShar(){
  VecOfAny* v = FIND_OBJECT(VecOfAny, rep->slot[4].oref);
    return v->length();}
BaseAssembly* CompositePart:: usedSharIndex(int i){
 VecOfAny* v = FIND_OBJECT(VecOfAny, rep->slot[4].oref);
 return FIND_OBJECT(BaseAssembly, v->fetch(i));
}
 CompositePart:: numParts(){
  VecOfAny* v = FIND_OBJECT(VecOfAny, rep->slot[5].oref);
    return v->length();
}
AtomicPart* CompositePart:: partsIndex(int i){
  VecOfAny* v = FIND_OBJECT(VecOfAny, rep->slot[5].oref);
  return FIND_OBJECT(AtomicPart, v->fetch(i));
}
AtomicPart* CompositePart:: rootPart(){
  return FIND_OBJECT(AtomicPart, rep->slot[6].oref);
}

Document:: Document(OR_obj* o): Thor_Object(o){
// title     slot[0].oref
// id        slot[1].value32[0]
// text      slot[2].oref
 }

String* Document:: title(){
  return FIND_OBJECT(String, rep->slot[0].oref);
}

int Document:: id(){
  return rep->slot[1].value32[0];
}
String* Document:: text(){
  return FIND_OBJECT(String, rep->slot[2].oref);
}
Manual:: Manual(OR_obj* o): Thor_Object(o){
// title     slot[0].oref
// id        slot[1].value32[0]
// text      slot[2].oref
}
String* Manual:: title(){
  return FIND_OBJECT(String, rep->slot[0].oref);
}
int Manual:: id(){
  return rep->slot[1].value32[0];
}

String* Manual:: text(){
  return FIND_OBJECT(String, rep->slot[2].oref);
}
int Manual:: textLen(){ 
  String* v= FIND_OBJECT(String, rep->slot[2].oref);
  return v->length();
}

Assembly:: Assembly(OR_obj* o): DesignObj(o){
// builddate     slot[0].value32[1]
// id            slot[0].value32[0]
// otype         slot[1].oref
// super         slot[2].oref
// mod           slot[3].oref
}

Assembly* Assembly:: superassembly(){
return FIND_OBJECT(Assembly, rep->slot[2].oref);
}
Module* Assembly:: module(){
return FIND_OBJECT(Module, rep->slot[3].oref);
}

ComplexAssembly:: ComplexAssembly(OR_obj* o) : Assembly(o){
// builddate     slot[0].value32[1]
// id            slot[0].value32[0]
// otype         slot[1].oref
// super         slot[2].oref
// mod           slot[3].oref
//children       slot[4].oref
}

int ComplexAssembly:: numAssemblies(){
  VecOfAny* v = FIND_OBJECT(VecOfAny, rep->slot[4].oref);
  return v->length();
  }

Assembly* ComplexAssembly::assemblyIndex(int i){
  VecOfAny* v = FIND_OBJECT(VecOfAny, rep->slot[4].oref);
  return FIND_OBJECT(Assembly, v->fetch(i));
}

BaseAssembly:: BaseAssembly(OR_obj* o): Assembly(o){
// builddate     slot[0].value32[1]
// id            slot[0].value32[0]
// otype         slot[1].oref
//  privChildren slot[2].oref
// shar Children slot[3].oref

}
 
 int BaseAssembly:: numComponentsPriv(){
   VecOfAny* v = FIND_OBJECT(VecOfAny, rep->slot[2].oref);
  return v->length();
   }
CompositePart* BaseAssembly::componentsPrivIndex(int i){
  VecOfAny* v = FIND_OBJECT(VecOfAny, rep->slot[2].oref);
  return FIND_OBJECT(CompositePart, v->fetch(i));
}
int BaseAssembly:: numComponentsShar(){
  VecOfAny* v = FIND_OBJECT(VecOfAny, rep->slot[3].oref);
  return v->length();
}
CompositePart* BaseAssembly::componentsSharIndex(int i){ 
  VecOfAny* v = FIND_OBJECT(VecOfAny, rep->slot[3].oref);
  return FIND_OBJECT(CompositePart, v->fetch(i));
}
  
Module:: Module(OR_obj* o): DesignObj(o){
// builddate     slot[0].value32[1]
// id            slot[0].value32[0]
// otype         slot[1].oref
// man           slot[2].oref
// assms         slot[3].oref
// root          slot[4].oref
}
 
Manual* Module::man(){
  return FIND_OBJECT(Manual, rep->slot[2].oref);
}

int Module:: numAssemblies(){ 
VecOfAny* v = FIND_OBJECT(VecOfAny, rep->slot[3].oref);
  return v->length();

 }

Assembly* Module:: assemblyIndex(int i){
  VecOfAny* v = FIND_OBJECT(VecOfAny, rep->slot[3].oref);
  return FIND_OBJECT(Assembly, v->fetch(i));
}
ComplexAssembly* Module:: designRoot(){
  return FIND_OBJECT(ComplexAssembly, rep->slot[4].oref);
}
// ...















