// Copyright 1995 Barbara Liskov

/*
\section{Update Thread Implementation}
 
XXX Possible race condition when two update threads run simultaneously:
can one truncate the VQ before the other has added objects to invalid sets?

*/

#include "utils/fail.h"
#include "thread.h"

#include "update.h"
#include "fe_map.h"
#include "or.h"
#include "or_config.h"
#include "tstatus.h"
#include "or_or_msg.h"
#include "tm.h"
#include "vqueue.h"

#include "mm/log.h"
#include "mm/logrecord.h"

class FE_manager;


Installer::Installer(Tid const& tid, Log_Index pl) {
    tid_   = tid;
    pl_    = pl;
}

Installer::~Installer() {
}

void Installer::main() {
    // Find transaction's prepare record
    Data_Log_Record *dr = (Data_Log_Record *) orx->log->fetch(pl_);    
    th_assert(dr != 0, "Missing prepare record for committed transaction");

    // Find FE manager of client that committed transaction
    Address a;
    FE_manager *mgr = NULL; 
	
    if (orx->tstatus->get_fe(tid_, a)) {
	// See if FE is still connected
	orx->fe_map->read_lock();
	mgr = orx->fe_map->fetch(a);
	orx->fe_map->read_unlock();
    }

    // Put new objects in FE table BEFORE installing transaction.
    // Other clients can fetch the objects and modify them after the
    // install, so the objects must already be in FE table.
    if (mgr) orx->tm->add_to_FE_table(mgr, dr->new_objects());

    // Install prepare record
    dr->commit();
    dr->install();
    
    // XXX Bug - FE can hang up between manager lookup and use in
    // add_to_invalid_sets.  

    // Add to invalid sets of FEs. This is
    // conservative since the objects have been installed and an FE may
    // have fetched the new version and still its version may be
    // invalidated
  
    int wsize;
    const Oref* wset = orx->tm->vq->get_write_set(&tid_, wsize);
    orx->tm->add_to_invalid_sets(mgr, wset, wsize);
    // Mark the transaction as installed
    orx->tm->mark_installed(&tid_);
    orx->log->installed(pl_);

    // Tell tstatus that we're done with transaction
    orx->tstatus->installed(tid_);

    orx->tm->truncate_vqueue_if_needed();

    if (orx->config->debug_level > 1)
	printf("Update thread done installing transaction results\n");
}

void start_update(Log_Index prepare_index, or_or_message *msg) {
    // XXX For now, just keep creating installer objects.
    //     Should delete them when thread ends.
    th_assert(msg->msgtype == OR_COMMIT,
	      "Bad message type passed to update thread");
    Installer *inst = new Installer(msg->tid, prepare_index);
    inst->start();
}
