#include "basic.h"
#include "wordsize.h"

#define INT_BITS (WORDBITS/INTS_PER_WORD)

class boolmatrix {
public:
    boolmatrix(int m, int n) {
	int size = (m*n + INT_BITS - 1)/INT_BITS;
	rowsize = n;
	data = new int[size];
    }
    ~boolmatrix() { delete data; }

    bool fetch(int i, int j) {
	int bit = i*rowsize + j;
	int index = bit/INT_BITS;
	return (data[index] & (1 << (bit & -INT_BITS))) ? TRUE : FALSE;
    }
    void store(int i, int j, bool b) {
	int bit = i*rowsize + j;
	int index = bit/INT_BITS;
	int bitshift = bit & -INT_BITS;
	int temp = data[index] & (~(1 << bitshift));
	if (b) temp |= (1 << bitshift);
	data[index] = temp;
    }
private:
    int rowsize;
    int *data;
};
