/*
\section{Global Timestamp}

This file implements a globally unique timestamp.
It is a stack abstraction so that we can overload the usual arithmetic
operations to work with timestamps.
*/

#ifndef _GLOBAL_TSTAMP_H
#define _GLOBAL_TSTAMP_H

#include <stdio.h>
#include "basic.h"
#include "bits.h"
#include "address.h"
#include "tstamp.h"

class Device;

class Global_tstamp {
    // A global timestamp is a <timestamp, address>.
    // The address serves to uniquify it.

  public:
    Global_tstamp();
    // effects - Uninitialized timestamp.

    Global_tstamp(Address a, Tstamp const& t);
    // effects - makes an object that is a global timestamp using
    //           address a and the local timestamp t.

    Global_tstamp(Global_tstamp const&);
    // Copy Constructor.
    
    void operator=(Global_tstamp const& t);
    // Assignment operator.

    bool operator<(Global_tstamp const& t)  const;
    // effects --- returns true iff this "<" t.
    //             Global timestamps are compared first on the timestamp,
    //             then on address.

    bool operator==(Global_tstamp const& t)  const;
    // effects --- returns true iff this "==" t.
    
    bool operator>(Global_tstamp const& t) const;
    // effects --- returns true iff this ">" t.

    Global_tstamp operator+(Bits32 increment) const;
    // effects --- incrments the timestamp by "increment" microseconds.

    Global_tstamp max (Global_tstamp& t) const;
    // effects --- returns max (this, t)
    
    bool same_address(Global_tstamp& t) const;
    // effects -- Returns TRUE if this and t have the same address

    bool encode(Device*) const;
    bool decode(Device*);

    void print (FILE *fp);

  private:
    // Representation. 
    Tstamp ltime;        // Local times.
    Address addr;        // Unique global address.  Must have <, >, == ops.
};

inline bool Global_tstamp::same_address(Global_tstamp& t) const {
    return addr == t.addr;
}

#endif /* _GLOBAL_TSTAMP_H */
