#include "bits.h"
#include "hashfuncs.h"

/*
The multiplicative hash function multiplies the value to be hashed
with a magic multiplier.  As suggested by Knuth, the multiplier
is chosen to be int(PHI * 2^n).  We chose "n = 30" so that "2^n" is
a legal positive value under twos-complement arithmetic.

A hash value in the range  "[0..2^k-1]" can be generated by taking
the top "k" bits of the bottom 30 bits of the value generated by
"hash_int".

The value "1737350767" is "int((sqrt(5) - 1)/2 * 2\^30)".
*/

#define PRECBITS (sizeof(int)<<3)

int hash_ubits64(Ubits64 x) {
#if defined __alpha
    /* XOR the hash values obtained from the lower and upper parts */
    return hash_int(x & ((1L << PRECBITS) - 1))   ^   hash_int((x >> PRECBITS));
#elif defined __linux__
    return hash_int(x & ((1ULL << PRECBITS) - 1))  ^  hash_int((x >> PRECBITS));
#else
    hash_ubits64 not defined for other machines
#endif
}


bool comp_int(int x, int y) { 
  return (x == y); 
}

/* String hashing out of The Dragon Book. */
int hash_string(char const* x) {
    char const* p;
    unsigned int h = 0;
    unsigned int g;

    for (p = x; *p != '\0'; p++) {
        h = (h << 4) + *p;
        if ((g = h & 0xf0000000)) {
            h = h ^ (g >> 24);
            h = h ^ g;
        }
    }
    return (int) h;
}



