/*
    Intentionally not protected by #ifndef's.  This file generates code for
    the class "Generator<GENERATOR_ELEMENT>". It should only be included
    exactly once per distinct GENERATOR_ELEMENT in a given program.

    Define GENERATOR_ELEMENT immediately before including this file.  The
    mapping is undefined by this file.  For example, to generate code for a
    generator of integers,

#define GENERATOR_ELEMENT int
#include "impl_generator.t"

*/

#include "generator.h"

#ifdef __DECCXX
#pragma define_template Generator<GENERATOR_ELEMENT>
#endif

#ifdef __GNUC__
template class  Generator<GENERATOR_ELEMENT>;
#endif

#undef GENERATOR_ELEMENT
