/*********************************************************************
    Intentionally not protected by #ifndef's! Define SET_ELEM
    immediately before including this file. It removes the definition
    for SET_ELEM, so it behaves like an argument to the file.
**********************************************************************/

/*
    This file instantiates the class "PtrSet<SET_ELEM>". It should
    only be included once per distinct SET_ELEM type.

    For example, a set of pointers to integers:

#define SET_ELEM int
#include "impl_ptrset.t"

    This implements the type "PtrSet<int>". It should be done
    only once in all the C++ source files, regardless of how many source
    files mention the type.
*/

#include "bhash.t"
#include "buckets.t"

#ifdef __DECCXX
#pragma define_template PtrSet<SET_ELEM>;
#endif

#ifdef __GNUC__
template class PtrSet<SET_ELEM>;
#endif

#undef SET_ELEM
