// \section{Link}
//
// A "Link" is an entry in a circular doubly linked list.
// Each link contains a "void*" pointer off to some external
// data structure.  Links are useful in implementing LRU
// or FIFO lists for data structures like caches and logs.

#ifndef _LINK_H
#define _LINK_H

class Link {
  public:
    Link();
    // effects	Make singleton list with null ptr

    ~Link();
    // effects	Remove from any list and then delete

    void append(Link* l);
    // effects	Append "l" to "this"

    void prepend(Link*);
    // effects	Prepend "l" to "this"

    void remove();
    // effects	Remove "this" from any list it is on and make singleton

    void* value;
    // Value associated with the link

    Link* next();
    // effects	Return next pointer

    Link* prev();
    // effects	Return prev pointer
  private:
    Link*	next_;
    Link*	prev_;
};

inline Link::Link() {
    value = 0;
    next_ = this;
    prev_ = this;
}

inline Link::~Link() {
    next_->prev_ = prev_;
    prev_->next_ = next_;
}

inline void Link::append(Link* l) {
    l->next_ = next_;
    l->prev_ = this;
    next_->prev_ = l;
    next_ = l;
}

inline void Link::prepend(Link* l) {
    l->next_ = this;
    l->prev_ = prev_;
    prev_->next_ = l;
    prev_ = l;
}

inline void Link::remove() {
    next_->prev_ = prev_;
    prev_->next_ = next_;
    next_ = this;
    prev_ = this;
}

inline Link* Link::next() {
    return next_;
}

inline Link* Link::prev() {
    return prev_;
}

#endif /* _LINK_H */
