/*
\section{Network Interface}

This is an interface to a device built on a TCP/IP stream.
*/

#ifndef _NETWORK_H
#define _NETWORK_H

#include "fdevice.h"
#include "address.h"
class Network_set;

class Network : public FDevice {
  public:
    Network(Address a, int sock, int bufsize=1024);
    // requires - sock is a connect TCP socket.
    // effects  - Create a transmission channel for the connection
    //		  inherent in sock.
    //            Sets the byte size of output buffer to bufsize.
    //            Sets the address of the network to "a".

    Network(Address a, Ubits32 host_addr, int port, 
	    bool& success, int bufsize=1024);
    // Creates a connection to the specified host_addr and port.
    // Sets the byte size of output buffer to bufsize.
    // Sets "success" to true if succeeded.
    // Sets the address of the network to "a".

    virtual ~Network();
    // effects  - Closes the transmission channel and the underlying
    //		  TCP connection/socket.

    void set_nodelay();
    // modifies - this
    // effects - set underlying net connection to send packets quickly 
    //           instead of waiting for packet to fill.  Only needs to
    //           be called once for the lifetime of the connection.

    void set_buffsizes(int send_bufsize, int recv_bufsize);
    // modifies - this
    // effects - set OS buffer sizes for sending and receiving messages..
    //           Only needs to be called once for the lifetime of the 
    //           connection.

    void allow_sigio();
    // effects: Allow SIGIO to be delivered to the process whenever
    //          a message is received on this connection

    virtual bool can_read();
    // effects	Returns true iff data is available for reading without
    //		blocking.

    virtual bool has_buffered_data();
    // effects	returns TRUE iff there is data buffered on the connection
    //          (in this abstraction's internal state)

    bool sloppy_read_bytes(void* ptr, int size, int* count);
    // XXX This doesn't belong here!  Need to rethink this
    //     interface for better performance at the FE.
    // effects - reads up to size bytes from network into buffer 
    //           pointed to by ptr.  Mutates count to be the actual
    //           number of bytes read.  Returns TRUE if all is well,
    //           FALSE otherwise.

    int wait_or_timeout(float sec);
    // effects Waits on the network connection until there is some input or
    //         it times out after sec seconds. Returns 0 if it times
    //         out, 1 if there is some input on the connection. If there is
    //         a connection error returns -1.

    Address address; // The address associated with this network.
    // (The address may be changed.)
   
  private:

    friend Network_set;  // NetworkSet should only use the following method

    int get_descriptor();
    // effects Returns file descriptor associated with this

}; 

#endif /* _NETWORK_H */
