#include "random.h"

#include <stdlib.h>
#include <math.h>

Random::Random() {srand48(1);}

void Random::seed(long seed_) {srand48(seed_);}

Composed_random::Composed_random(double p1, Random *rand1, Random *rand2)
    : prob1(p1), random1(rand1), random2(rand2) {}

double Composed_random::next() {
    double r = drand48();
    if (r < prob1) return random1->next(); 
    else return random2->next();
}

Uniform_random::Uniform_random(double mean_, double spread_)
    : mean(mean_), spread(spread_) {}

double Uniform_random::next() {
    return (drand48()-0.5)*spread+mean;
}

Exponential_random::Exponential_random(double sd): s(sd) {}

double Exponential_random::next() {
    double r  = drand48();
    bool neg = true; // whether to negate result
    double r2 = r;
    if (r >= 0.5)  {
	neg = false;
	r2 = r-0.5;
    }
    // assert 0 <= r2 < 0.5
    double x = s*log(1-2*r2);
    if (neg) return -x; 
    else return x;
}

Normal_random::Normal_random(double mean, double sd, int accuracy)
    : uniforms(accuracy) 
{
    offset = mean-uniforms/2.0;
    factor = sqrt(12.0/uniforms)*sd;
}

double Normal_random::next()
// Approximates normal random by adding uniform randoms.
{
    double sum = 0;
    for (int i = 0; i < uniforms; i++) sum += drand48();
    return (sum+offset)*factor;
}
