#ifndef _THREAD_POOL_H
#define _THREAD_POOL_H

// A pool of threads handle messages concurrently from the communication
// interface. Useful in a multithreaded server.

#include "thread.h"

class Communication;

class Pool_thread: public Thread {
    // Abstract: this is one of the threads in a pool to handle messages.
public:
    Pool_thread(Communication *com_);
    // Create a thread to handle messages from "com_".

    virtual ~Pool_thread() {}

    virtual void main();
    // Loops to handle messages, blocking indefinitely to get a message.

private:
    Communication *com; // to handle messages from
    Pool_thread(); // disallowed
};


#include "array.h"
typedef Thread *Threadp;
declareArray(Threads, Threadp)

class Thread_pool {
public:    
    Thread_pool(Communication *com);
    // Creates a pool of zero threads to handle messages from "com".

    ~Thread_pool();
    // Deletes all threads in the pool.

    void add(unsigned int nthreads);
    // Requires non-concurrent invocation of this method.
    // Add "nthreads" threads to the pool, and starts them.

private:
    Communication *com;  // the networks interface
    unsigned int nthreads;    // number of threads
    Threads threads;     // the threads
};

#endif /* _THREAD_POOL_H */
