#ifndef _TIMED_LOG_H
#define _TIMED_LOG_H

// A "Timed_log" is an array of integers timestamped at the time
// they were added to the log. 
// Time is measured relative to a start point.
// Currently set up to gather and print statistical information.


#include "utils/Timer.h"
#include "utils/array.h"
class ostream;

struct Timed_entry {
    float time;
    int entry;
};

declareArray(Timed_entries, Timed_entry)

class Timed_log {
public:
    Timed_log(Timer &timer);
    // Creates an empty log using specified "timer".
    // The "timer" may be operated externally.

    void append(int entry);
    // adds an entry with the current time

    int high();
    // Requires that log is not empty.
    // Returns the last entry.

    void print(ostream *out);
    // prints out pairs of time and entry in the log, one pair per line.

private:
    Timed_log(); // disallowed
    Timed_entries timed_entries;
    Timer &timer;
};
 

#endif /* _TIMED_LOG_H */
