#include <stdio.h>
#include <other_unix.h>
#include "device.h"
#include "tstamp.h"

Ubits64 Tstamp::last_issued = 0;

Tstamp::Tstamp(bool generate) {
    usecs = 0;
    if (!generate) return;
    struct timezone dummy;     // Ignoring the timezone information.
    struct timeval  time_;

    gettimeofday(&time_, &dummy);
    usecs = time_.tv_sec * Microsecs + time_.tv_usec;
    if (usecs <= last_issued) {
        // Have to generate something > "last_issued"
        usecs = last_issued + 1;
    }
    last_issued = usecs;
}

bool Tstamp::encode(Device* dev) const {
    return (dev->send_buffer(this, sizeof(Tstamp)));
}

bool Tstamp::decode(Device* dev) {
    return (dev->recv_buffer(this, sizeof(Tstamp)));
}

void Tstamp::print (FILE *fp) {
#ifdef __linux__
    fprintf(fp, "LTime: s = %-llu Us = %-llu", usecs/Microsecs, usecs%Microsecs);
#else
    fprintf(fp, "LTime: s = %-lu Us = %-lu", usecs/Microsecs, usecs%Microsecs);
#endif
}
