/*
\section{Word Size Macros}

*/

#ifndef _WORDSIZE_H
#define _WORDSIZE_H

#include "basic.h"

#define BYTEALIGNED(x) (TRUE)
#define TWOBYTEALIGNED(x) ~((0x1L & (x)) | 0x1)
#define FOURBYTEALIGNED(x) ~((0x3L & (x)) | 0x3)
#define EIGHTBYTEALIGNED(x) ~((0x7L & (x)) | 0x7)

#define NEXT_BYTE(x) x
#define NEXT_TWOBYTE(x) (((x) + 1) & (-2))
#define NEXT_FOURBYTE(x) (((x) + 3) & (-4))
#define NEXT_EIGHTBYTE(x) (((x) + 7) & (-8))

#ifdef __alpha

#define WORDBYTES 8
#define WORDBITS 64
#define WORDONES 0xFFFFFFFFFFFFFFFFLU
#define WORDZEROS 0x0000000000000000LU
#define LONGS_PER_WORD 1
#define INTS_PER_WORD 2
#define SHORTS_PER_WORD 4
#define WORDALIGNED(x) EIGHTBYTEALIGNED(x)
#define LONGALIGNED(x) EIGHTBYTEALIGNED(x)
#define INTALIGNED(x) FOURBYTEALIGNED(x)
#define SHORTALIGNED(x) TWOBYTEALIGNED(x)

#else /* __alpha */

#define WORDBYTES 4
#define WORDBITS 32
#define WORDONES 0xFFFFFFFFLU
#define WORDZEROS 0x00000000LU
#define LONGS_PER_WORD 1
#define INTS_PER_WORD 1
#define SHORTS_PER_WORD 2
#define WORDALIGNED(x) FOURBYTEALIGNED(x)
#define LONGALIGNED(x) FOURBYTEALIGNED(x)
#define INTALIGNED(x) FOURBYTEALIGNED(x)
#define SHORTALIGNED(x) TWOBYTEALIGNED(x)

#endif /* __alpha */

#define NEXT_WORD(x) (((x) + WORDBYTES - 1) & (- WORDBYTES))
#define NEXT_LONG(x) (((x) + sizeof(long) - 1) & (- sizeof(long)))
#define NEXT_INT(x) (((x) + sizeof(int) - 1) & (- sizeof(int)))
#define NEXT_SHORT(x) (((x) + sizeof(short) - 1) & (- sizeof(short)))

#ifdef __alpha
#define EIGHTBYTE 
#endif

#ifdef EIGHTBYTE
#define POINTER_BYTES 8
#define POINTER_VALUE(x) ((ubits64)(x))
#else
#define POINTER_BYTES 4
#define POINTER_VALUE(x) ((ubits32)(x))
#endif /* EIGHTBYTE */

/* Align on quadword boundary */
#define QUADALIGN(x) (ubits64*)(POINTER_VALUE(x) & (~ 0x3L))


#endif /* _WORDSIZE_H */
